/*
 * @(#)PertDiagram.java  1.0  2006-01-18
 *
 * Copyright (c) 2006 Lucerne University of Applied Sciences and Arts (HSLU)
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by the Lucerne University of Applied 
 * Sciences and Arts (HSLU). You may not use, copy or modify this software, 
 * except in accordance with the license agreement you entered into with HSLU. 
 * For details see accompanying license terms. 
 */

package ch.hslu.cm.pert.diagram;

import ch.hslu.cm.*;
import ch.hslu.cm.pert.model.*;
import ch.hslu.cm.simulation.*;
import ch.randelshofer.util.*;
import java.awt.*;
import java.awt.geom.*;
import java.util.*;
import javax.swing.*;
/**
 * A Relational Entity-Realationship Diagram.
 *
 *
 * @author Werner Randelshofer
 * @version 1.0 2006-01-18  Created.
 */
public class PertDiagram extends AbstractDiagram {
    public final static Color
            TASK_CONNECTOR_COLOR = Color.black,
            TASK_NAME_COMPARTMENT_COLOR = Color.white,
            TASK__ATTRIBUTE_COMPARTMENT_COLOR = Color.white,
            TASK_FILL_COLOR = Color.white,
            TASK_STROKE_COLOR = Color.black,
            TASK_TYPE_COLOR = new Color(0x666666),
            TASK_TEXT_COLOR = Color.black,
            TASK_SHADOW_COLOR = new Color(0xbbbbbb),
            DEPENDENCY_STROKE_COLOR = new Color(0x000099),
            DEPENDENCY_FILL_COLOR = Color.white,
            DEPENDENCY_TEXT_COLOR = Color.black
            ;
    public final static double DIAGRAM_STROKE_WIDTH = 1d;
    
    public final static int TASK_LAYER = 0;
    public final static int DEPENDENCY_LAYER = 1;
    
    /** Creates a new instance. */
    public PertDiagram() {
        this(new PertModel());
    }
    public PertDiagram(PertModel simulation) {
        setSimulation(simulation);
    }
    public PertModel getPertModel() {
        return (PertModel) getSimulation();
    }
    
    protected DiagramFigure createDiagramFigure(SimulatedElement simElem) {
        switch (simElem.getSimulatedConcept()) {
            case PertModel.TASK : {
                TaskFigure f = new TaskFigure();
                f.setModel((Task) simElem);
                return f;
            }
            case PertModel.DEPENDENCY : {
                DependencyFigure f = new DependencyFigure();
                f.setModel((Dependency) simElem);
                return f;
            }
            default :
                return null;
        }
    }
}
